/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpd;

import com.ibm.hwmca.base.vpd.VpdDisketteErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class VpdDisketteFile
implements VpdDisketteErrorIds {
    private static final String TRACE_MASKT = "XRASDIST";
    private static final String TRACE_MASKF = "XRASDISF";
    private static final String TRACE_MASKD = "XRASDISD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(97, "DisketteFile");
    protected String content;
    protected File file;

    private ByteArrayOutputStream readAndConvertData(String path) throws HException {
        Trace.trace(TRACE_MASKD, "-> readAndConvertData()");
        ByteArrayOutputStream f0 = new ByteArrayOutputStream();
        try {
            FileInputStream f = new FileInputStream(path);
            File file = new File(path);
            byte[] buf = new byte[(int)file.length()];
            ((InputStream)f).read(buf);
            int i = 0;
            while (i < buf.length) {
                buf[i] = buf[i] == 0 ? 32 : buf[i];
                ++i;
            }
            f0.write(buf);
            Trace.trace(TRACE_MASKD, "buf =" + buf.toString());
            ((InputStream)f).close();
        }
        catch (Exception exc) {
            System.out.println("caught exception: " + exc.getMessage());
            Trace.trace(TRACE_MASKF, "Read Reassign HMC Diskette file failed");
            HException rexc = new HException("Read Reassign Diskette File failed");
            new FrameworkLog(logInfo, 28934, rexc).log(FrameworkLogAttributes.INFO_LOG);
            throw rexc;
        }
        Trace.trace(TRACE_MASKD, "<- readAndConvertData()");
        return f0;
    }

    public VpdDisketteFile(String path) {
        Trace.trace(TRACE_MASKD, "-> VpdDisketteFile ctor ");
        try {
            this.file = new File(path);
            this.content = new String();
            ByteArrayOutputStream b = this.readAndConvertData(path);
            this.content = b.toString();
            b.close();
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "reading vpdDiskette File failed " + exc.getMessage());
            HException rexc = new HException("Read and Convert Reassign Diskette File failed");
            new FrameworkLog(logInfo, 28934, rexc).log(FrameworkLogAttributes.INFO_LOG);
        }
        Trace.trace(TRACE_MASKD, "content  = " + this.content);
        Trace.trace(TRACE_MASKD, "<- VpdDisketteFile ctor ");
    }

    public boolean checkForValidData() {
        Trace.trace(TRACE_MASKT, "<> checkForValidData() has to be overwritten by subclasses");
        return true;
    }

    public boolean exists() {
        Trace.trace(TRACE_MASKT, "<> exists() ");
        return this.file.exists() && this.content.length() != 0;
    }

    public String getContent() {
        return this.content;
    }

    public File getFile() {
        return this.file;
    }
}

